<?php

namespace RtRasel\LaravelInstaller\Providers;

use Illuminate\Routing\Router;
use Illuminate\Support\ServiceProvider;
use RtRasel\LaravelInstaller\Middleware\canInstall;
use RtRasel\LaravelInstaller\Middleware\canUpdate;
use RtRasel\LaravelInstaller\Middleware\canVerify;
use RtRasel\LaravelInstaller\Middleware\CheckInstallation;
use RtRasel\LaravelInstaller\Middleware\CheckLicense;
use RtRasel\LaravelInstaller\Middleware\VerifyLicense;

class LaravelInstallerServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->publishFiles();
        $this->loadRoutesFrom(__DIR__.'/../Routes/web.php');
        $this->loadViewsFrom(__DIR__.'/../Views', 'laravelinstaller');
    }

    /**
     * Bootstrap the application events.
     *
     * @param  \Illuminate\Routing\Router  $router
     */
    public function boot(Router $router)
    {
        $router->middlewareGroup('install', [canInstall::class]);
        $router->middlewareGroup('update', [canUpdate::class]);
        $router->middlewareGroup('verify', [canVerify::class]);
        $router->middlewareGroup('checkInstallation', [CheckInstallation::class]);
        $router->middlewareGroup('checkLicense', [CheckLicense::class]);
        $router->middlewareGroup('verifyLicense', [VerifyLicense::class]);
    }

    /**
     * Publish file for the installer.
     *
     * @return void
     */
    protected function publishFiles()
    {
        $this->publishes([
            __DIR__.'/../assets' => public_path('installer'),
        ], 'laravelinstaller');
    }
}
